using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public partial class REFERRALDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public REFERRALDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public IEnumerable<VIRP.CRS.BO.REFERRAL_LIST> SearchReferrals(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string REFERRAL_STATUS_CODE,
            string PATIENT_LAST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            List<CRS.BO.REFERRAL_LIST> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_ReferralSearch(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            REFERRAL_STATUS_CODE,
                            PATIENT_LAST_NAME,
                            SORT_COLUMN,
                            START_ROW,
                            MAX_ROWS)
                        .ToList();

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public int SearchReferralsCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string REFERRAL_STATUS_CODE,
            string PATIENT_LAST_NAME)
        {
            int? objReturn = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_ReferralSearchCount(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            REFERRAL_STATUS_CODE,
                            PATIENT_LAST_NAME,
                            ref objReturn);

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn.HasValue ? objReturn.Value : 0;
        }

        public REFERRAL GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32? VIRP_ReFerral_ID)
        {
            REFERRAL objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, VIRP_ReFerral_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public REFERRAL GetItemByReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            REFERRAL objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitemByReferral(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int GetReferralOriginalRecordCount(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            int? objReturn = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    
                    objReturn = dbContext
                        .usp_REFERRAL_getReferralOriginalRecordCount(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            REFERRAL_ID,
                            ref objReturn);
                    
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return (int)objReturn;
        }

        public VIRP.CRS.BO.REFERRAL GetDuplicate(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID, string PATIENT_SNUM)
        {
            VIRP.CRS.BO.REFERRAL objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getDuplicate(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID, PATIENT_SNUM).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<REFERRAL> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<REFERRAL> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public EFRHealthFactorsByReferral GetHealthFactors(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            EFRHealthFactorsByReferral objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getHealthFactors(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }
        
        public List<REFERRAL_DETAIL> GetHealthFactorsComplete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<REFERRAL_DETAIL> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getHealthFactorsComplete(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<VIRP.CRS.BO.WKF_CASE_ACTIVITY> GetBioFollowups(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<VIRP.CRS.BO.WKF_CASE_ACTIVITY> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKFCASEACTIVITY_getBioFollowups(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public DateTime? GetReferralDateByPatientId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            DateTime? objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_EFR_GetReferralDateByPatientId(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REFERRAL objSave)
        {
            Int32? objReturn = objSave.VIRP_ReFerral_ID;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_REFERRAL_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.ADDRESS_LINE1, objSave.ADDRESS_LINE2, objSave.ADDRESS_LINE3, objSave.CITY, objSave.COUNTRY, objSave.COUNTY, DateTime.Now, objSave.CREATEDBY, objSave.DUPLICATE_FLAG, objSave.ORDERBY_PROVIDER_ADDRESS_LINE1, objSave.ORDERBY_PROVIDER_ADDRESS_LINE2, objSave.ORDERBY_PROVIDER_ADDRESS_LINE3, objSave.ORDERBY_PROVIDER_CITY, objSave.ORDERBY_PROVIDER_COUNTRY, objSave.ORDERBY_PROVIDER_EMAIL, objSave.ORDERBY_PROVIDER_FAX, objSave.ORDERBY_PROVIDER_ID_NUMBER, objSave.ORDERBY_PROVIDER_NAME, objSave.ORDERBY_PROVIDER_PHONE, objSave.ORDERBY_PROVIDER_POSTAL_CODE, objSave.ORDERBY_PROVIDER_STATE, objSave.ORDERBY_PROVIDER_ZIP_PLUS_4, objSave.PATIENT_ID, objSave.POSTAL_CODE, objSave.PROVIDER_ADDRESS_LINE1, objSave.PROVIDER_ADDRESS_LINE2, objSave.PROVIDER_ADDRESS_LINE3, objSave.PROVIDER_CITY, objSave.PROVIDER_COUNTRY, objSave.PROVIDER_COUNTY, objSave.PROVIDER_EMAIL, objSave.PROVIDER_FAX, objSave.PROVIDER_ID_NUMBER, objSave.PROVIDER_NAME, objSave.PROVIDER_PHONE, objSave.PROVIDER_POSTAL_CODE, objSave.PROVIDER_STATE, objSave.PROVIDER_ZIP_PLUS_4, objSave.REFERRAL_ID, objSave.REVIEW_BY, objSave.REVIEW_DATE, objSave.STATE, objSave.STD_INSTITUTION_ID, objSave.STD_REFERRALRANK_ID, objSave.STD_REMINDERCLASS_ID, DateTime.Now, objSave.UPDATEDBY, objSave.VAMC_CONTACT_EMAIL, objSave.VAMC_CONTACT_FAX, objSave.VAMC_CONTACT_NAME, objSave.VAMC_CONTACT_PHONE, objSave.VIRP_Patient_ID, ref objReturn, objSave.ZIP_PLUS_4);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32? VIRP_ReFerral_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_REFERRAL_delete(CURRENT_USER, CURRENT_REGISTRY_ID, VIRP_ReFerral_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<EfrStatistics> GetEfrCountStatistics(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<EfrStatistics> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.GetEfrCountStatistics().ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<ReferralsGetListByPatientResult> SelectByPatientId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            List<ReferralsGetListByPatientResult> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_PATIENTREFERRALS_byPatientId(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<ReferralCase> GetCasesByReferralId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<ReferralCase> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_getExtendedByReferralId(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<WorkflowcaseActivity> SelectByCaseId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ACTIVITY_CASE_ID, Int32 ACTIVITY_CASE_TYPE_ID)
        {
            List<WorkflowcaseActivity> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getExtendedByActivityId(CURRENT_USER, CURRENT_REGISTRY_ID, ACTIVITY_CASE_ID, ACTIVITY_CASE_TYPE_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<VIRP.CRS.BO.WKF_CASE_ACTIVITY> GetFollowupActivitiesByReferralId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<VIRP.CRS.BO.WKF_CASE_ACTIVITY> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getFollowUpByReferralId(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int GetFragmentFileCount(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            int? objReturn = 0;
            int retValue = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_EFR_GetDoDFragmentFilesCountByPatientId(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID, ref objReturn);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            if (objReturn != null)
                retValue = (int)objReturn;

            return retValue;
        }
        public IEnumerable<ReferralFollowUp> GetReferralFollowups(
           string CURRENT_USER,
           int CURRENT_REGISTRY_ID,
           string PATIENT_LAST_NAME,
           string SORT_COLUMN,
           int? START_ROW,
           int? MAX_ROWS)
        {
            List<ReferralFollowUp> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_REFERRALFOLLOWUPS_getItems(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_LAST_NAME,
                            SORT_COLUMN,
                            START_ROW,
                            MAX_ROWS)
                        .ToList();

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public int GetReferralFollowupsCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_LAST_NAME) 
        {
            int? objReturn = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_REFERRALFOLLOWUPS_getItemCounts(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_LAST_NAME,
                            ref objReturn);

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn.HasValue ? objReturn.Value : 0;
        }
        #endregion
    }
}
